/*
 * Info.java
 *
 * Created on 22. Februar 2004, 13:50
 */

package VierGewinnt;


import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import java.awt.*;
import java.net.*;

/**
 *
 * @author  stmu
 */
public class Info extends JDialog implements HyperlinkListener{
    JEditorPane editor;
    JScrollPane scroller;
    Fourwins vier;

    public Info(Fourwins vier,URL datei){
        this.vier = vier;
        initGui(datei);
    }

    void initGui(URL datei){
        this.setTitle(vier.getTitle());
        this.setModal(true);
        int hoehe = vier.getHeight();
        int breite = vier.getWidth();
        int x = vier.getX();
        int y = vier.getY();
        this.setBounds(x+breite/8,y+hoehe/8,breite*3/4,hoehe*3/4);
        this.getContentPane().setLayout(new BorderLayout());
        editor = new JEditorPane();
        editor.addHyperlinkListener(this);
        editor.setEditable(false);
        try {
            editor.setPage(datei);
        }catch (IOException e) {
            e.printStackTrace();
            editor.setText(e.getMessage());
            System.err.println(e.getMessage());
        }
        scroller = new JScrollPane(editor);
        scroller.setVerticalScrollBarPolicy(
            JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        scroller.setHorizontalScrollBarPolicy(
            JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        this.getContentPane().add(scroller,BorderLayout.CENTER);
        this.setVisible(true);
        this.repaint();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        //System.out.println(e.getDescription());
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane) e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            }
            else{
                try{
                    pane.setPage(e.getURL());
                }catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

}
