package VierGewinnt;

import javax.swing.*;
import java.io.*;
import java.awt.event.*;
import java.util.*;
import java.awt.*;


public class Spielfeld extends JPanel{
	Fourwins vier;
	int hoehe,breite,kopfhoehe,kopfbreite,qSeite;
	int Pfeilfeld=3;
	int nPfeil=7;
	int xPfeil[] = new int[nPfeil];
	int yPfeil[] = new int[nPfeil];
	int pfeilbreite;
	int stellung[]=new int[2];
	final int WEISS = 0;
	final int SCHWARZ = 1;
	final int ANZAHLZEILEN = 6;
	final int ANZAHLSPALTEN = 7;
	int lastZug[][] = new int[43][3];
	int zugNr;


	public Spielfeld(Fourwins vier){
                for(int i=0;i<43;i++){
			lastZug[i][0]=0;
			lastZug[i][1]=0;
			lastZug[i][2]=0;
		}
                this.vier = vier;
                stellung[0]=vier.feld0;
		stellung[1]=vier.feld1;
                zugNr = getSpalte(0)+getSpalte(1)+getSpalte(2)+getSpalte(3)+
                        getSpalte(4)+getSpalte(5)+getSpalte(6);
                lastZug[zugNr][0]=stellung[0];
                lastZug[zugNr][1]=stellung[1];
                lastZug[zugNr][2]=3;//damit am Anfang der Pfeil in der Mitte steht
	}

	public int getZugNr(){
		return zugNr;
	}

	public void paint(Graphics g){
		g.setColor(Color.lightGray);
		g.fillRect(0,0,breite,hoehe);
		zeichneSpielfeld(g);
		zeichneStellung(g);
		//Pfeil malen
		malePfeil(g);
		//super.paint(g);
	}

	public void setStellung(int m0,int m1){
		stellung[0]=m0;
		stellung[1]=m1;
		vier.m0.setText("m0 = "+stellung[0]);
		vier.m1.setText("m1 = "+stellung[1]);
		paint(this.getGraphics());
	}

	public void setPfeilfeld(int m){
		Pfeilfeld = m;
	}

	public void zugZurueck(){
            System.out.println("zugzurck: "+zugNr);
                if(zugNr == 0){
			vier.toolkit.beep();
			return;
		}
		/*if(zugNr == 0){
			zugNr = -1;
			setPfeilfeld(3);
			setStellung(0,0);
			return;
		}*/
		zugNr--;
		setPfeilfeld(lastZug[zugNr][2]);
		setStellung(lastZug[zugNr][0],lastZug[zugNr][1]);
		paint(this.getGraphics());
	}
	
	public void zugVor(){
            System.out.println("zugvor: "+zugNr);
		if( zugNr == 42 ){
			vier.toolkit.beep();
			return;
		}
		zugNr++;
		setPfeilfeld(lastZug[zugNr][2]);
		setStellung(lastZug[zugNr][0],lastZug[zugNr][1]);
		paint(this.getGraphics());
	}

	void zeichneStellung(Graphics g){
		zugNr = 0;
		int zeile;
		int spalte;
		for( zeile=5;zeile>=0;zeile--){
			for(spalte=0;spalte<7;spalte++){
				if( getSpalte(spalte)>=zeile+1 ){
					if( getBit(7*zeile+spalte) == WEISS ){
						zeichneStein(g,zeile,spalte,WEISS);
					}
					else{
						zeichneStein(g,zeile,spalte,SCHWARZ);
					}
					zugNr++;
				}
				else{
					zeichneStein(g,zeile,spalte,2);//wird wieder blau gezeichnet.
				}
			}
		}
		vier.zugNr.setText("Anzahl Zge: "+zugNr);
		/*for(int i=0;i<zugNr;i++){
			System.out.println("lastZug[i][1]: "+lastZug[i][1]+"  i:"+i);
		}*/
	}

	public String amZug(){
		if( getBit(42)==SCHWARZ ){
			return "SCHWARZ";
		}
		else{
			return "WEISS";
		}
	}

	public void setze(int x, int y){
		int spalte;
		if( x < kopfbreite || y < kopfhoehe || x > kopfbreite + 7*qSeite
				|| y > kopfhoehe + 6*qSeite){
			vier.toolkit.beep();
		}
		else{
			spalte = (x-kopfbreite)/qSeite;
			setze(this.getGraphics(),spalte);
		}
	}

	public void setze(Graphics g,int spalte){
		int tmp1,tmp3;
		int hoehe;
// in m stehen die 64 bit
// m[1] sind die Bit 32-63
// Bit 63 in m entspricht Bit 31 in m[1]
		if( spalte >= ANZAHLSPALTEN || spalte < 0){
   		meldung("Fehler in Fkt 'setze()': Variable Spalte ungueltig");
			vier.toolkit.beep();
			return;
   	}
   	hoehe = getSpalte(spalte);
		if( hoehe >= 6 ){//Spalte ist schon voll
   		meldung("Spalte "+spalte+" ist schon voll");
			vier.toolkit.beep();
			return;
   	}
		setPfeilfeld(spalte);
		//zeichnen des Steins
		zeichneStein( g,hoehe,spalte,getBit(42) );
		//zeichnen des Steins
		zugNr++;
		vier.zugNr.setText("Anzahl Zge: "+zugNr);
   	if( hoehe == 5 ){// nach setzen ist die Spalte voll
   		setBit(63-spalte);
   	}
		tmp1 = 43+2*spalte;//Bits, wo die Spalten gesetzt sind
   	if( getBit(42) == SCHWARZ ){
			setBit(hoehe*7+spalte);
			unsetBit(tmp1);//ganz oben sitzt jetzt ein schwarzer Stein
      	unsetBit(tmp1+1);//      "
   	}
   	else{
   		tmp3 = getBit(tmp1+1);
      	if( tmp3 == 0 ){
      		setBit(tmp1+1);
      	}
      	else{
     			setBit(tmp1);
         	unsetBit(tmp1+1);
      	}
   	}
   	if( getBit(42)==1 ) unsetBit(42);
   	else setBit(42);
		setPfeilfeld(spalte);
		lastZug[zugNr][0]=stellung[0];
		lastZug[zugNr][1]=stellung[1];
		lastZug[zugNr][2]=Pfeilfeld;
		vier.m0.setText("m0 = "+stellung[0]);
		vier.m1.setText("m1 = "+stellung[1]);
		this.repaint();
	}

	void zeichneStein(Graphics g,int zeile,int spalte,int farbe){
		if( farbe == WEISS ){
			g.setColor(Color.white);
		}
		else if( farbe == SCHWARZ ){
			g.setColor(Color.black);
		}
		else{
			g.setColor(Color.blue);//Feld wird gelscht
		}
		g.fillOval(kopfbreite+spalte*qSeite+qSeite/4,kopfhoehe+(5-zeile)*qSeite+qSeite/4,qSeite/2,qSeite/2);
	}

	void meldung(String meld){
		System.out.println(meld);
	}

	int getBit(int position){
		int tmp1;
		int n=1;
		if( position < 0 || position > 63 ){
   		meldung("position: "+position);
   		meldung("Ueberlauf in getBit");
			return -1;
   	}
   	if( position > 31 ){
   		tmp1=stellung[1];
      	position = position - 32;
   	}
   	else tmp1=stellung[0];
   	tmp1 = tmp1 >> position;
   	//printf("position: %d,m0: %d\n",position,m0);
   	return n & tmp1;
	}

	void setBit(int position){
		//printf("Aufruf von setBit %d\n",position);
		int tmp1,tmp2;
   	int n=1;
		tmp2 = 0;//speichert, welche der beiden integers gendert wurden
		if( position < 0 || position > 63 ){
   		meldung("position: "+position);
   		meldung("Ueberlauf in setBit");
      	return;
   	}
   	if( position > 31 ){
   		tmp2 = 1;
   		tmp1=stellung[1];
      	position = position - 32;
   	}
   	else tmp1=stellung[0];
   	n = n << position;
   	stellung[tmp2] = tmp1 | n;
	}

	void unsetBit(int position){
		int tmp1,tmp2;
		int n=1;
		tmp2 = 0;//speichert, welche der beiden integers gendert wurden
		if( position < 0 || position > 63 ){
   		meldung("position: "+position);
   		meldung("Ueberlauf in unsetBit");
      	return;
   	}
   	if( position > 31 ){
   		tmp2 = 1;
   		tmp1=stellung[1];
      	position = position - 32;
   	}
   	else tmp1=stellung[0];
   	n = n << position;
   	n = ~n;
   	stellung[tmp2]=tmp1 & n;
	}


	int getSpalte(int spalte){
		int tmp1,tmp2,tmp3;
		int rueckWert;
	// in m stehen die 64 bit
	// m[1] sind die Bit 32-63
	// Bit 63 in m entspricht Bit 31 in m[1]
		if( spalte >= ANZAHLSPALTEN || spalte < 0){
   		meldung("Fehler in Fkt 'getSpalte()': Variable Spalte ungueltig");
			rueckWert = -1;
   	}
		else if( getBit(63-spalte)==1 ){//Spalte ist voll
   		rueckWert = ANZAHLZEILEN;
   	}
   	else{
			tmp1 = 43+2*spalte;//Bits, wo die Spalten gesetzt sind
      	tmp2 = getBit(tmp1);
      	tmp3 = getBit(tmp1+1);
      	tmp1 = 2*tmp2+tmp3;//Ausgerechnet wie viele weisse Steine oben sitzen
      	tmp2 = 28+spalte;//in der obersten Spalte kann kein schwarzer Stein sein,
      	// da dort berhaupt kein Stein sitzt. Es wird in der ausgewhlten Spalte
      	// von oben nach unten gesucht, ob ein schwarzer Stein dort sitzt.
      	tmp3 = 5;
      	for( ;tmp2>=0;tmp3--,tmp2=tmp2-ANZAHLSPALTEN ){
      		if( getBit(tmp2)==1 )break;
      	}
      	rueckWert = tmp3+tmp1;
      	//printf("Hoehe: %d\t Schwarz: %d\n",rueckWert,tmp3);
   	}
   return rueckWert;
	}

	void zeichneSpielfeld(Graphics g){
		hoehe = this.getHeight();
		breite = this.getWidth();
		qSeite = hoehe/8;
		pfeilbreite = qSeite/2;
		kopfhoehe = qSeite/2;
		kopfbreite = (breite-7*qSeite)/2;
		g.setColor(Color.blue);
		g.fillRect(kopfbreite,kopfhoehe,7*qSeite,6*qSeite);
		g.setColor(Color.black);
		for(int i=0;i<7;i++){
			g.drawLine(kopfbreite,kopfhoehe+i*qSeite,kopfbreite+7*qSeite,kopfhoehe+i*qSeite);
		}
		for(int i=0;i<8;i++){
			g.drawLine(kopfbreite+i*qSeite,kopfhoehe,kopfbreite+i*qSeite,kopfhoehe+6*qSeite);
		}
	}

	void malePfeil(Graphics g){
		if( getBit(42)==WEISS ){
			g.setColor(Color.black);
		}
		else{
			g.setColor(Color.white);
		}
		xPfeil[0]=kopfbreite+Pfeilfeld*qSeite+qSeite/2;
		yPfeil[0]=kopfhoehe+6*qSeite+qSeite/2;
		xPfeil[1]=xPfeil[0]+pfeilbreite/2;
		yPfeil[1]=yPfeil[0]+pfeilbreite/2;
		xPfeil[2]=xPfeil[1]-pfeilbreite/4;
		yPfeil[2]=yPfeil[1];
		xPfeil[3]=xPfeil[2];
		yPfeil[3]=yPfeil[2]+qSeite/3;
		xPfeil[4]=xPfeil[3]-pfeilbreite/2;
		yPfeil[4]=yPfeil[3];
		xPfeil[5]=xPfeil[4];
		yPfeil[5]=yPfeil[2];
		xPfeil[6]=xPfeil[5]-pfeilbreite/4;
		yPfeil[6]=yPfeil[5];
		g.fillPolygon(xPfeil,yPfeil,nPfeil);
	}

}
