package VierGewinnt;

import javax.swing.*;
import java.io.*;
import java.awt.event.*;
import java.util.*;
import java.awt.*;


public class Spielfeld2 extends JPanel{
	Fourwins vier;
        Color hintergrund,vordergrund,vordergrund2,gewonnenFarbe;
	int hoehe,breite,kopfhoehe,kopfbreite,qSeite;
	int Pfeilfeld=3;
	int nPfeil=7;
	int xPfeil[] = new int[nPfeil];
	int yPfeil[] = new int[nPfeil];
	int pfeilbreite;
	int stellung[]=new int[2];
	final int WEISS = 0;
	final int SCHWARZ = 1;
	final int ANZAHLZEILEN = 6;
	final int ANZAHLSPALTEN = 7;
	int lastZug[][] = new int[43][3];
	int zugNr;
        static boolean gewonnen=false;
        int feldRot[] = new int[22];

	public Spielfeld2(Fourwins vier){
                hintergrund = Color.lightGray;
                vordergrund2 = Color.blue;
                vordergrund = Color.blue;
                gewonnenFarbe = new Color(200,0,0);
                for(int i=0;i<43;i++){
			lastZug[i][0]=0;
			lastZug[i][1]=0;
			lastZug[i][2]=0;
		}
                for(int i=0;i<feldRot.length;i++){
                    feldRot[i]=-1;
                }
                this.vier = vier;
                stellung[0]=vier.feld0;
		stellung[1]=vier.feld1;
                try{
                zugNr = Tools.getSpalte(stellung,0)+Tools.getSpalte(stellung,1)+
                        Tools.getSpalte(stellung,2)+Tools.getSpalte(stellung,3)+
                        Tools.getSpalte(stellung,4)+Tools.getSpalte(stellung,5)+
                        Tools.getSpalte(stellung,6);
                }catch(Exception e){
                    //System.err.println(e.getMessage());
                    //vier.toolkit.beep();
                    vier.meldung(e.getMessage(),true);
                }
                lastZug[zugNr][0]=stellung[0];
                lastZug[zugNr][1]=stellung[1];
                setPfeilfeld(3);//damit am Anfang der Pfeil in der Mitte steht
                lastZug[zugNr][2]=3;//damit am Anfang der Pfeil in der Mitte steht
	}

	public int getZugNr(){
		return zugNr;
	}
        
        public void zieh(int stufe)throws Exception{
            if( vier.pause ) return;
            final int spalte;
            switch(stufe){
                case -1:
                    spalte=vier.tester.stufeNegativ(stellung);
                    break;
                case 0:
                    spalte=vier.tester.stufe0(stellung);
                    break;
                case 1:
                    spalte=vier.tester.stufe1(stellung);
                    break;
                case 2:
                    spalte=vier.tester.stufe2(stellung);
                    break;
                case 3:
                    spalte=vier.tester.stufe3(stellung);
                    break;
                case 4:
                    spalte=vier.tester.stufeExe(stellung,4);
                    break;
                case 5:
                    spalte=vier.tester.stufeExe(stellung,5);
                    break;
                case 6:
                    spalte=vier.tester.stufeExe(stellung,6);
                    break;
                case 7:
                    spalte=vier.tester.stufe7(stellung);
                    break;
                case 8:
                    spalte=vier.tester.stufe8(stellung);
                    break;
                case 9:
                    spalte=vier.tester.stufe9(stellung);
                    break;
                case 10:
                    spalte=vier.tester.stufe10(stellung);
                    break;
                default:
                    throw new Exception("Unerlaubte Spielstufe gewhlt");
            }
            if( !vier.pause && ( (this.amZug()==0 && vier.isComputer1 )
                                || (this.amZug()==1 && vier.isComputer2 ) ) ){
                 final Runnable grafik = new Runnable() {
                     public void run() {
                         String meldung="";
                         try{
                             setze(getGraphics(),spalte,true);
                         }
                         catch(Exception e){
                             meldung = e.getMessage();
                         }
                         if( !meldung.equals("") ) vier.meldung(meldung,true);
                     }
                 };
                 try{
                     SwingUtilities.invokeAndWait(grafik);
                 }catch(Exception e){
                     vier.meldung(e.getMessage(),true);
                 }
            }
        }

	public void paint(Graphics g){
		g.setColor(hintergrund);
		g.fillRect(0,0,breite,hoehe);
		zeichneSpielfeld(g);
                try{
                    zeichneStellung(g);
                    malePfeil(g);
                }catch(Exception e){
                    vier.meldung(e.getMessage(),true);
                }
	}

	public void setStellung(int m0,int m1){
		stellung[0]=m0;
		stellung[1]=m1;
		vier.m0.setText("m0 = "+stellung[0]);
		vier.m1.setText("m1 = "+stellung[1]);
                this.repaint();
	}

	public void setPfeilfeld(int m){
		Pfeilfeld = m;
	}
        
        public int amZug(){
            try{
                return Tools.getBit(this.stellung,42);
            }catch(Exception e){
                vier.meldung(e.getMessage(),true);
                return -1;
            }
        }

	public void zugZurueck(int anzahlZuege){
            vier.meldung("",false);
                if(zugNr < anzahlZuege){
			vier.toolkit.beep();
			return;
		}
                this.gewonnen = false;
		zugNr = zugNr - anzahlZuege;
		setPfeilfeld(lastZug[zugNr][2]);
		setStellung(lastZug[zugNr][0],lastZug[zugNr][1]);
	}
	
	public void zugVor(){
            int nr = zugNr;
               if( zugNr == 42 ){
			vier.toolkit.beep();
			return;
		}
                if( lastZug[zugNr+1][0]!=0 || lastZug[zugNr+1][1]!=0 ){
                    try{
                        setze(this.getGraphics(),lastZug[zugNr+1][2],false);
                    }catch(Exception e){
                        zugNr = nr+1;
                        vier.meldung(e.getMessage(),true);
                        setPfeilfeld(lastZug[zugNr][2]);
                        setStellung(lastZug[zugNr][0],lastZug[zugNr][1]);
                    }
                }
                else{
                    vier.meldung("letzter Zug\nwurde erreicht",true);
                }
	}

	void zeichneStellung(Graphics g)throws Exception{
		zugNr = 0;
		int zeile;
		int spalte;
		for( zeile=5;zeile>=0;zeile--){
			for(spalte=0;spalte<7;spalte++){
				if( Tools.getSpalte(stellung,spalte)>=zeile+1 ){
                                        if( Tools.getBit(stellung,7*zeile+spalte) == WEISS ){
						zeichneStein(g,zeile,spalte,WEISS);
					}
					else{
						zeichneStein(g,zeile,spalte,SCHWARZ);
					}
					zugNr++;
				}
				else{
					zeichneStein(g,zeile,spalte,2);//wird wieder blau gezeichnet.
				}
			}
		}
		vier.zugNr.setText("Anzahl Zge: "+zugNr);
	}

	/*public String amZug()throws Exception{
		if( Tools.getBit(stellung,42)==SCHWARZ ){
			return "SCHWARZ";
		}
		else{
			return "WEISS";
		}
	}*/

	public void setze(int x, int y){
		int spalte;
		if( x < kopfbreite || y < kopfhoehe || x > kopfbreite + 7*qSeite
				|| y > kopfhoehe + 6*qSeite){
			vier.toolkit.beep();
		}
                else if( (x-kopfbreite)%qSeite==0 ){//auf einen Rand gesetzt
                        vier.toolkit.beep();
                }
		else{
			spalte = (x-kopfbreite)/qSeite;
                        try{
                            setze(this.getGraphics(),spalte,true);
                        }catch(Exception e){
                            vier.meldung(e.getMessage(),true);
                        }
		}
	}
        
	public void setze(Graphics g,int spalte,boolean loeschen)throws Exception{
            /**
             *Vorsicht: Neue Definition fr das Spielfeld:
             *  Bit 0-42 wie bisher
             *  Bit 43-63 je 3 Bit von Spalte 0 bis 6 fr die Hhe
             *              in Binrdarstellung
             */
            int hoehe;
// in m stehen die 64 bit
// m[1] sind die Bit 32-63
// Bit 63 in m entspricht Bit 31 in m[1]
            if( spalte >= ANZAHLSPALTEN || spalte < 0){
                vier.meldung("Fehler in Fkt 'setze()':\nVariable Spalte ungueltig",true);
		return;
            }
            hoehe = Tools.getSpalte(stellung,spalte);
            if( hoehe >= 6 ){//Spalte ist schon voll
                vier.meldung("Spalte "+(spalte+1)+" ist schon voll",true);
                return;
            }
            if( gewonnen ){
                vier.meldung("Spiel ist bereits entschieden",true);
                return;
            }
            this.gewonnen = Tools.gewinnt(this,stellung,spalte);
            setPfeilfeld(spalte);
            //zeichnen des Pfeils
            zeichneStein( g,hoehe,spalte,Tools.getBit(stellung,42) );
            //zeichnen des Steins
            zugNr++;
            vier.zugNr.setText("Anzahl Zge: "+zugNr);
            int tmp2 = 7*hoehe+spalte;
            if( Tools.getBit(stellung,tmp2) != Tools.getBit(stellung,42) ){
                if( Tools.getBit(stellung,tmp2) == WEISS ){
                    stellung=Tools.setBit(stellung,tmp2);
                }
                else{
                    stellung=Tools.unsetBit(stellung,tmp2);
                }
            }
            
            int tmp1 = 43+3*spalte;
            while( Tools.getBit(stellung,tmp1)==1 ){
                stellung=Tools.unsetBit(stellung,tmp1);
                tmp1++;
            }
            stellung=Tools.setBit(stellung,tmp1);
            
            if( gewonnen ){//durch diesen Stein wurde gewonnen
                if( Tools.getBit(stellung,42)==0 ){
                    if( vier.isComputer1 ){
                        vier.meldung("\n"+vier.farbe1.trim()+"\nhat gewonnen !!!",true);
                    }
                    else{
                        if( vier.gewonnenClip != null ){
                            if( vier.sound ) vier.gewonnenClip.play();
                            vier.meldung("\n"+vier.player1a.getText()+"\nhat gewonnen !!!",false);
                        }
                        else{
                            vier.meldung("\n"+vier.player1a.getText()+"\nhat gewonnen !!!",true);
                        }
                    }
                    if( !vier.isComputer1 && vier.isComputer2 ){
                        vier.setIcon(3);
                    }
                    else if( vier.isComputer1 && !vier.isComputer2 ){
                        vier.setIcon(4);
                    }
                }
                else{
                    if( vier.isComputer2 ){
                        vier.meldung("\n"+vier.farbe2.trim()+"\nhat gewonnen !!!",true);
                    }
                    else{
                        if( vier.gewonnenClip != null ){
                            if( vier.sound ) vier.gewonnenClip.play();
                            vier.meldung("\n"+vier.player2a.getText()+"\nhat gewonnen !!!",false);
                        }
                        else{
                            vier.meldung("\n"+vier.player2a.getText()+"\nhat gewonnen !!!",true);
                        }
                    }
                    if( !vier.isComputer1 && vier.isComputer2 ){
                        vier.setIcon(4);
                    }
                    else if( vier.isComputer1 && !vier.isComputer2 ){
                        vier.setIcon(3);
                    }
                }
            }
            else{
                int anzahl=0;
                for(int i=0;i<7;i++){
                    anzahl += Tools.getSpalte(stellung,i);
                }
                if( anzahl == 42 ){
                    vier.unentschieden();
                }
            }
            
            if( Tools.getBit(stellung,42)==1 ) stellung=Tools.unsetBit(stellung,42);
            else stellung=Tools.setBit(stellung,42);
            setPfeilfeld(spalte);
            lastZug[zugNr][0]=stellung[0];
            lastZug[zugNr][1]=stellung[1];
            lastZug[zugNr][2]=Pfeilfeld;
            vier.m0.setText("m0 = "+stellung[0]);
            vier.m1.setText("m1 = "+stellung[1]);
            
            if(loeschen){
                for(int i=zugNr+1;i<43;i++){
                    for(int j=0;j<3;j++){
                        lastZug[i][j]=0;
                    }
                }
            }
            
            this.repaint();
	}
        
	void zeichneStein(Graphics g,int zeile,int spalte,int farbe){
            /*Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_RENDERING,
                                RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                                RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
                                RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS,
                                RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING,
                                RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_DITHERING,
                                RenderingHints.VALUE_DITHER_ENABLE);*/
            if( vier.schwarz == null || vier.weiss == null ){
		if( farbe == WEISS ){
			g.setColor(Color.white);
		}
		else if( farbe == SCHWARZ ){
			g.setColor(Color.black);
		}
		else{
			g.setColor(vordergrund2);//Feld wird gelscht
		}
		g.fillOval(kopfbreite+spalte*qSeite+qSeite/4,
                     kopfhoehe+(5-zeile)*qSeite+qSeite/4,qSeite/2-1,qSeite/2-1);
            }
            else{
                int groesse = 8;
                ImageIcon stein;
                if( farbe == WEISS || farbe == SCHWARZ){
                    if( farbe == WEISS ){
                        stein = vier.weiss;
                    }
                    else{
                        stein = vier.schwarz;
                    }
                    g.drawImage(stein.getImage(),kopfbreite+spalte*qSeite+qSeite/groesse+1,
                        kopfhoehe+(5-zeile)*qSeite+qSeite/groesse+1,qSeite*(groesse-2)/groesse,
                        qSeite*(groesse-2)/groesse,vier);
                }
                else{
                    g.setColor(vordergrund2);
                    g.fillOval(kopfbreite+spalte*qSeite+qSeite/groesse+1,
                        kopfhoehe+(5-zeile)*qSeite+qSeite/groesse+1,
                        qSeite*(groesse-2)/groesse-1,qSeite*(groesse-2)/groesse-1);
                }
            }
	}

	void zeichneSpielfeld(Graphics g){
		hoehe = this.getHeight();
		breite = this.getWidth();
		qSeite = Math.min((int)(hoehe/7.5),breite/8);
		pfeilbreite = qSeite/2;
		kopfhoehe = qSeite/2;
		kopfbreite = (breite-7*qSeite)/2;
		g.setColor(vordergrund);
		g.fillRect(kopfbreite,kopfhoehe,7*qSeite,6*qSeite);
                g.setColor( gewonnenFarbe );
                int j=0;
                while( feldRot[j] != -1 ){// wird von 0 bis 41 gezhlt
                    g.fillRect(kopfbreite+qSeite*(feldRot[j]%7),
                                kopfhoehe+qSeite*(5-feldRot[j]/7),
                                qSeite,qSeite);
                    j++;
                }
		g.setColor(Color.black);
		for(int i=0;i<7;i++){
			g.drawLine(kopfbreite,kopfhoehe+i*qSeite,kopfbreite+7*qSeite,kopfhoehe+i*qSeite);
		}
		for(int i=0;i<8;i++){
			g.drawLine(kopfbreite+i*qSeite,kopfhoehe,kopfbreite+i*qSeite,kopfhoehe+6*qSeite);
		}
	}

	void malePfeil(Graphics g)throws Exception{
            if( Pfeilfeld == -1 ){
                vier.meldung("Pfeil wurde nicht gemalt",false);
                return;
            }
            if( vier.pfeil == null ){
		if( Tools.getBit(stellung,42)==WEISS ){
			g.setColor(Color.black);
		}
		else{
			g.setColor(Color.white);
		}
		xPfeil[0]=kopfbreite+Pfeilfeld*qSeite+qSeite/2;
		yPfeil[0]=kopfhoehe+6*qSeite+qSeite/2;
		xPfeil[1]=xPfeil[0]+pfeilbreite/2;
		yPfeil[1]=yPfeil[0]+pfeilbreite/2;
		xPfeil[2]=xPfeil[1]-pfeilbreite/4;
		yPfeil[2]=yPfeil[1];
		xPfeil[3]=xPfeil[2];
		yPfeil[3]=yPfeil[2]+qSeite/3;
		xPfeil[4]=xPfeil[3]-pfeilbreite/2;
		yPfeil[4]=yPfeil[3];
		xPfeil[5]=xPfeil[4];
		yPfeil[5]=yPfeil[2];
		xPfeil[6]=xPfeil[5]-pfeilbreite/4;
		yPfeil[6]=yPfeil[5];
		g.fillPolygon(xPfeil,yPfeil,nPfeil);
            }
            else{
                g.drawImage(vier.pfeil.getImage(),kopfbreite+Pfeilfeld*qSeite+qSeite/4,
                                                    kopfhoehe+6*qSeite+qSeite/4,
                                                    qSeite/2,qSeite*2/3,vier);
            }
	}
        
        void maleTipPfeil(Graphics g,int Pfeilfeld,int wert){
            g.setColor(hintergrund);
            g.fillRect(kopfbreite+Pfeilfeld*qSeite,kopfhoehe+6*qSeite+qSeite/8,
                                                qSeite,qSeite);
            ImageIcon tmp;
            if( wert > 0 ){
                tmp = vier.smiley4;
            }
            else if(wert == 0){
                tmp = vier.smiley2;
            }
            else{
                tmp = vier.smiley3;
            }
            g.drawImage(tmp.getImage(),kopfbreite+
                                                    Pfeilfeld*qSeite+qSeite/8,
                                                    kopfhoehe+6*qSeite+qSeite/8+qSeite/8,
                                                    qSeite-qSeite/4,
                                                    qSeite-qSeite/4,vier);
	}

}
