package VierGewinnt;

import java.io.*;
import java.util.Vector;

class Tools{
    
    final static int ANZAHLSPALTEN = 7;
    final static int WEISS = 0;
    final static int SCHWARZ = 1;
    
    
    public static int[] setze(int spielfeld[],int spalte)throws Exception{
        /**
         *Vorsicht: Neue Definition fr das Spielfeld:
         *  Bit 0-42 wie bisher
         *  Bit 43-63 je 3 Bit von Spalte 0 bis 6 fr die Hhe
         *              in Binrdarstellung
         */
        int hoehe;
// in m stehen die 64 bit
// m[1] sind die Bit 32-63
// Bit 63 in m entspricht Bit 31 in m[1]
        if( spalte >= ANZAHLSPALTEN || spalte < 0){
            return spielfeld;
        }
        hoehe = getSpalte(spielfeld,spalte);
        if( hoehe >= 6 ){//Spalte ist schon voll
            throw new Exception("Spalte "+spalte+" ist schon voll! ");
        }
        int tmp2 = 7*hoehe+spalte;
        if( getBit(spielfeld,tmp2) != getBit(spielfeld,42) ){
            if( getBit(spielfeld,tmp2) == WEISS ){
                spielfeld = setBit(spielfeld,tmp2);
            }
            else{
                spielfeld = unsetBit(spielfeld,tmp2);
            }
        }

        int tmp1 = 43+3*spalte;
        while( getBit(spielfeld,tmp1)==1 ){
            spielfeld = unsetBit(spielfeld,tmp1);
            tmp1++;
        }
        spielfeld = setBit(spielfeld,tmp1);

        if( getBit(spielfeld,42)==1 ) spielfeld = unsetBit(spielfeld,42);
        else spielfeld = setBit(spielfeld,42);
        
        return spielfeld;
    }
    
    static int testeDatei(int m[],int spalte,File dataDir,int anzahlSteine)throws Exception{
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        anzahlSteine++;
        return testeDatei2(n,dataDir,anzahlSteine);
    }

    static int testeDatei2(int n[],File dataDir,int anzahlSteine)throws Exception{
        int i;
        int zahl = 0;
        int hoehen[] = new int[7];
        boolean spiegeln;
        int zaehler = 0;
        for(i=0;i<7;i++){
            hoehen[i] = Tools.getSpalte(n,i);
        }
        if( hoehen[0]>hoehen[6] )spiegeln = false;
        else if( hoehen[0] < hoehen[6] )spiegeln = true;
        else if( hoehen[1] > hoehen[5] )spiegeln = false;
        else if( hoehen[1] < hoehen[5] )spiegeln = true;
        else if( hoehen[2] > hoehen[4] )spiegeln = false;
        else if( hoehen[2] < hoehen[4] )spiegeln = true;
        else spiegeln = false;
        if( spiegeln ){
            n = Tools.spiegel(n);
            i=hoehen[0];hoehen[0]=hoehen[6];hoehen[6]=i;
            i=hoehen[1];hoehen[1]=hoehen[5];hoehen[5]=i;
            i=hoehen[2];hoehen[2]=hoehen[4];hoehen[4]=i;
        }
        for(i=0;i<7;i++){
            for(int j=0;j<hoehen[i];j++){
                if(Tools.getBit(n,7*j+i)==SCHWARZ){
                    zahl=Tools.setBit(zahl,zaehler);
                }
                zaehler++;
            }
        }
        String a = Integer.toString(hoehen[0]);
        String b = Integer.toString(hoehen[1]);
        File dir = new File(dataDir,a+b);
        if( !dir.isDirectory() ){
            throw new Exception(dir.getAbsolutePath()+" ist kein Verzeichnis");
        }
        String tmp=a+b+Integer.toString(hoehen[2])+
            Integer.toString(hoehen[3])+Integer.toString(hoehen[4])+
            Integer.toString(hoehen[5])+Integer.toString(hoehen[6]);
        File datei = new File(dir,tmp+"u.dat");
        if( !datei.isFile() ){
            throw new Exception(datei.getAbsolutePath()+" ist keine Datei");
        }
        if( inDatei2(datei,zahl,anzahlSteine) ){
            return 0;
        }
        datei = new File(dir,tmp+"n.dat");
        if( !datei.isFile() ){
            throw new Exception(datei.getAbsolutePath()+" ist keine Datei");
        }
        //Rckgabewert soll eigentlich nur negativ/positiv sein
        //nicht klar in wie vielen Schritten verloren/gewonnen wird
        //nur die spalte ist eindeutig
        if( inDatei2(datei,zahl,anzahlSteine) ){
            return -1;
        }
        else{
            return 1;
        }
    }
    
    static boolean inDatei(File datei,int zahl,int anzahlSteine)throws Exception{
        RandomAccessFile in = new RandomAccessFile(datei,"r");
        int anzahlBytes = (anzahlSteine+7)/8;
        if( in.getFilePointer() >= datei.length() ){
            in.close();
            return false;
        }
        int tmp=in.readUnsignedByte();
        for(int i=1;i<anzahlBytes;i++){
            tmp = tmp | (in.readUnsignedByte() << 8*i);
        }
        int zeile = 1;
        while(in.getFilePointer()<datei.length()){
            int vergl = vergleiche(zahl,tmp);
            if( vergl<=0 ){
                in.close();
                if( vergl == 0 ){
                    return true;
                }
                else return false;
            }
            tmp = in.readUnsignedByte();
            for(int i=1;i<anzahlBytes;i++){
                tmp = tmp | (in.readUnsignedByte() << 8*i);
            }
            zeile++;
        }
        if( vergleiche(zahl,tmp) == 0 ){
            return true;
        }
        in.close();
        return false;
    }
    
    static boolean inDatei2(File datei,int zahl,int anzahlSteine)throws Exception{
        RandomAccessFile in = new RandomAccessFile(datei,"r");
        long anfang = 0;
        int anzahlBytes = (anzahlSteine+7)/8;
        long ende = datei.length();
        if( ende < 9 ){
            in.close();
            return inDatei(datei,zahl,anzahlSteine);
        }
        long tmp = (ende+anfang)/2;
        long mitte = tmp-tmp%anzahlBytes;
        int wert;
        while(mitte != anfang){
            in.seek(mitte);
            wert=in.readUnsignedByte();
            for(int i=1;i<anzahlBytes;i++){
                wert = wert | (in.readUnsignedByte() << 8*i);
            }
            int vergl = vergleiche(zahl,wert);
            if( vergl == 0 ){
                in.close();
                return true;
            }
            if( vergl < 0 )ende = mitte;
            else anfang = mitte;
            tmp = (ende+anfang)/2;
            mitte = tmp - tmp%anzahlBytes;
            //System.out.println("Anfang: "+anfang+" Mitte: "+mitte+" Ende: "+ende);
        }
        if( mitte == 0 ){
            in.seek(mitte);
            wert=in.readUnsignedByte();
            for(int i=1;i<anzahlBytes;i++){
                wert = wert | (in.readUnsignedByte() << 8*i);
            }
            in.close();
            int vergl = vergleiche(zahl,wert);
            if( vergl == 0 )return true;
        }
        in.close();
        return false;
    }
    
    static int vergleiche(int zahl,int zahl2)throws Exception{
        if( zahl > zahl2 ) return 1;
        if( zahl < zahl2 ) return -1;
        return 0;
    }
    
    /*Pruefen soll beschleunigt werden, indem Funktion auf 
     *berechnete Daten in Dateien zurueckgreift
     */
    static int spielDatei(Fourwins vier,int n[],int spieltiefe,boolean optimiert) throws Exception{
                            //gibt die Spalte zurck,in die gesetzt werden soll
        int m[] = new int[2];
        m[0] = n[0];
        m[1] = n[1];
        int anzahlSiege = 0;
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(m,i) == 6 )rueckWert[i]=-1000;
            else{
                if( Tools.gewinnt(m,i) ){
                    return i;
                }
                rueckWert[i] = -500;//muss noch berechnet werden
            }
        }
        int anzahlSteine = Tools.getSpalte(m,0)+Tools.getSpalte(m,1)+
            Tools.getSpalte(m,2)+Tools.getSpalte(m,3)+Tools.getSpalte(m,4)+
            Tools.getSpalte(m,5)+Tools.getSpalte(m,6);
        if( vier.dataListe.indexOf(","+Integer.toString(anzahlSteine+1)+",") != -1 ){
            for(int i=0;i<7;i++){
                if( rueckWert[i] != -1000 ){
                    try{
                        rueckWert[i] = Tools.testeDatei(m,i,vier.dataDir,anzahlSteine);
                        if( rueckWert[i] <0 ){
                            anzahlSiege++;
                        }
                        else if( rueckWert[i]==0 ){
                            anzahlUnentschieden++;
                        }
                        else{
                            anzahlNiederlagen++;
                        }
                    }catch(Exception e){
                        e.printStackTrace();
                        System.err.println(e.getMessage());
                        rueckWert[i]=-500;
                    }
                }
            }
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] != -500 ) continue;
            vier.meldung("Prfe: \nSpalte: "+(i+1),false);
            rueckWert[i]=Tools.pruefDatei(m,spieltiefe,i,vier.dataListe,vier.dataDir,anzahlSteine);
            if( rueckWert[i] <0 ){
                anzahlSiege++;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        vier.meldung("",false);
        if( anzahlSiege > 0 ){//gewonnen
            if( anzahlSteine%2 == 0 ){
                vier.anzeigeL1.setText("Spieler1");
                vier.anzeigeL2.setText("kann gewinnen");
            }
            else{
                vier.anzeigeL1.setText("Spieler2");
                vier.anzeigeL2.setText("kann gewinnen");
            }
            int wert = -1;
            int zufall = (int)(Math.random()*anzahlSiege+1);
            while( zufall > 0 ){
                wert++;
                if( rueckWert[wert]<0 && rueckWert[wert] != -1000 )zufall--;
            }
            return wert;
        }
        if( anzahlUnentschieden > 0 ){//unentschieden
            vier.anzeigeL1.setText("Unentschieden");
            vier.anzeigeL2.setText("");
            if(optimiert){
                //Hier wird nicht das umkopierte Spielfeld genommen
                return wenigUnentschieden(vier,n);
            }
            else{
                int wert = -1;
                int zufall = (int)(Math.random()*anzahlUnentschieden+1);
                while( zufall > 0 ){
                    wert++;
                    if( rueckWert[wert]==0 )zufall--;
                }
                return wert;
            }
        }
        if( anzahlNiederlagen > 0 ){//verloren
            if( anzahlSteine%2 == 0 ){
                vier.anzeigeL1.setText("Spieler2");
                vier.anzeigeL2.setText("kann gewinnen");
            }
            else{
                vier.anzeigeL1.setText("Spieler1");
                vier.anzeigeL2.setText("kann gewinnen");
            }
            if(optimiert){
                //Hier wird nicht das umkopierte Spielfeld genommen
                return wenigSiege(vier,n);
            }
            else{
                int wert = 0;
                for(int i=0;i<7;i++){
                    if( rueckWert[i] == -1000){
                        wert = wert*10+3;
                    }
                    else{
                        wert = wert*10+1;
                    }
                }
                return wert;//C-Programm darf in jede nichtvolle Spalte setzen
            }
        }
        throw new Exception("Spielfeld ist schon voll");
    }
    
    static int wenigSiege(Fourwins vier,int m[])throws Exception{
        int wert=10000,tmp;
        Vector spalte = new Vector();
        int n[]=new int[2];
        for(int i=0;i<7;i++){
            n[0]=m[0];
            n[1]=m[1];
            if( Tools.getSpalte(n,i)==6 )continue;
            n = Tools.setze(n,i);
            tmp = Tools.anzahlSiege(vier,n,8);
            if( tmp < wert || spalte.size() == 0 ){
                wert = tmp;
                spalte = new Vector();
                spalte.add(new Integer(i));
            }
            else if( tmp == wert ){
                spalte.add(new Integer(i));
            }
        }
        if( spalte.size() > 0 ){
            int zufall=(int)(Math.random()*spalte.size());
            return ((Integer)spalte.get(zufall)).intValue();
        }
        else throw new Exception("Spielfeld ist schon voll\n"+
            "Exception in Funktion wenigSiege");
    }
    
    static int wenigUnentschieden(Fourwins vier,int m[])throws Exception{
        int wert=10000,tmp;
        Vector spalte = new Vector();
        int n[]=new int[2];
        for(int i=0;i<7;i++){
            n[0]=m[0];
            n[1]=m[1];
            if( Tools.getSpalte(n,i)==6 )continue;
            n = Tools.setze(n,i);
            tmp = Tools.anzahlUnentschieden(vier,n,8);
            if( tmp < wert || spalte.size() == 0 ){
                wert = tmp;
                spalte = new Vector();
                spalte.add(new Integer(i));
            }
            else if( tmp == wert ){
                spalte.add(new Integer(i));
            }
        }
        if( spalte.size() > 0 ){
            int zufall=(int)(Math.random()*spalte.size());
            return ((Integer)spalte.get(zufall)).intValue();
        }
        else throw new Exception("Spielfeld ist schon voll\n"+
            "Exception in Funktion wenigUnentschieden");
    }
    
    static int anzahlSiege(Fourwins vier,int n[],int spieltiefe) throws Exception{
                            //gibt die Spalte zurck,in die gesetzt werden soll
        int m[] = new int[2];
        m[0] = n[0];
        m[1] = n[1];
        //damit nicht jedes Mal gleich gespielt wird
        int zufall=(int)(Math.random()*5);
        int anzahlSiege = 0;
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(m,i) == 6 )rueckWert[i]=-1000;
            else{
                if( Tools.gewinnt(m,i) ){
                    return 1000+zufall;//beste Mglichkeit fr Gegner
                }
                rueckWert[i] = -500;//muss noch berechnet werden
            }
        }
        int anzahlSteine = Tools.getSpalte(m,0)+Tools.getSpalte(m,1)+
            Tools.getSpalte(m,2)+Tools.getSpalte(m,3)+Tools.getSpalte(m,4)+
            Tools.getSpalte(m,5)+Tools.getSpalte(m,6);
        if( vier.dataListe.indexOf(","+Integer.toString(anzahlSteine+1)+",") != -1 ){
            for(int i=0;i<7;i++){
                if( rueckWert[i] != -1000 ){
                    try{
                        rueckWert[i] = Tools.testeDatei(m,i,vier.dataDir,anzahlSteine);
                        if( rueckWert[i] <0 ){
                            anzahlSiege++;
                        }
                        else if( rueckWert[i]==0 ){
                            anzahlUnentschieden++;
                        }
                        else{
                            anzahlNiederlagen++;
                        }
                    }catch(Exception e){
                        e.printStackTrace();
                        System.err.println(e.getMessage());
                        rueckWert[i]=-500;
                    }
                }
            }
            if( anzahlSiege == 1 && anzahlUnentschieden == 0 ){
                //Hier soll auch nicht unbedingt hingesetzt werden, da sonst 
                //ein offensichtlicher Zug vom Gegner erzwungen wird
                return (int)2.5*zufall;
            }
            return anzahlSiege*10-2*anzahlUnentschieden-4*anzahlNiederlagen+zufall;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] != -500 ) continue;
            vier.meldung("Prfe: \nSpalte: "+(i+1),false);
            rueckWert[i]=Tools.pruefDatei(m,spieltiefe,i,vier.dataListe,vier.dataDir,anzahlSteine);
            if( rueckWert[i] <0 ){
                anzahlSiege++;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        vier.meldung("",false);
        if( anzahlSiege == 1 && anzahlUnentschieden == 0 ){
            //Hier soll auch nicht unbedingt hingesetzt werden, da sonst 
            //ein offensichtlicher Zug vom Gegner erzwungen wird
            return (int)2.5*zufall;
        }
        return anzahlSiege*10-2*anzahlUnentschieden-4*anzahlNiederlagen+zufall;
    }
    
    static int anzahlUnentschieden(Fourwins vier,int n[],int spieltiefe) throws Exception{
                            //gibt die Spalte zurck,in die gesetzt werden soll
        int m[] = new int[2];
        m[0] = n[0];
        m[1] = n[1];
        //Es soll nicht jedes Mal gleich gesetzt werden
        int zufall=(int)(Math.random()*5);
        int anzahlSiege = 0;
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(m,i) == 6 )rueckWert[i]=-1000;
            else{
                if( Tools.gewinnt(m,i) ){
                    return 1000+zufall;//beste Mglichkeit fr Gegner
                }
                rueckWert[i] = -500;//muss noch berechnet werden
            }
        }
        int anzahlSteine = Tools.getSpalte(m,0)+Tools.getSpalte(m,1)+
            Tools.getSpalte(m,2)+Tools.getSpalte(m,3)+Tools.getSpalte(m,4)+
            Tools.getSpalte(m,5)+Tools.getSpalte(m,6);
        if( vier.dataListe.indexOf(","+Integer.toString(anzahlSteine+1)+",") != -1 ){
            for(int i=0;i<7;i++){
                if( rueckWert[i] != -1000 ){
                    try{
                        rueckWert[i] = Tools.testeDatei(m,i,vier.dataDir,anzahlSteine);
                        if( rueckWert[i] <0 ){
                            anzahlSiege++;
                        }
                        else if( rueckWert[i]==0 ){
                            anzahlUnentschieden++;
                        }
                        else{
                            anzahlNiederlagen++;
                        }
                    }catch(Exception e){
                        e.printStackTrace();
                        System.err.println(e.getMessage());
                        rueckWert[i]=-500;
                    }
                }
            }
            if( anzahlSiege >= 1 ){
                return 900+zufall;
            }
            return 2*anzahlUnentschieden-2*anzahlNiederlagen+zufall;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] != -500 ) continue;
            vier.meldung("Prfe: \nSpalte: "+(i+1),false);
            rueckWert[i]=Tools.pruefDatei(m,spieltiefe,i,vier.dataListe,vier.dataDir,anzahlSteine);
            if( rueckWert[i] <0 ){
                anzahlSiege++;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        vier.meldung("",false);
        if( anzahlSiege >= 1 ){
            return 900+zufall;
        }
        return 2*anzahlUnentschieden-2*anzahlNiederlagen+zufall;
    }
    
    static int pruefDatei(Fourwins vier,int n[],int spieltiefe) throws Exception{
                            //gibt die Spalte zurck,in die gesetzt werden soll
        int m[] = new int[2];
        m[0] = n[0];
        m[1] = n[1];
        boolean unentschieden = false;
        boolean niederlage = false;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(m,i) == 6 )rueckWert[i]=-1000;
            else{
                if( Tools.gewinnt(m,i) ){
                    return 1;
                }
                rueckWert[i] = -500;//muss noch berechnet werden
            }
        }
        int anzahlSteine = Tools.getSpalte(m,0)+Tools.getSpalte(m,1)+
            Tools.getSpalte(m,2)+Tools.getSpalte(m,3)+Tools.getSpalte(m,4)+
            Tools.getSpalte(m,5)+Tools.getSpalte(m,6);
        if( vier.dataListe.indexOf(","+Integer.toString(anzahlSteine)+",") != -1 ){
            return Tools.testeDatei2(m,vier.dataDir,anzahlSteine);
        }
        if( vier.dataListe.indexOf(","+Integer.toString(anzahlSteine+1)+",") != -1 ){
            for(int i=0;i<7;i++){
                if( rueckWert[i] != -1000 ){
                    try{
                        rueckWert[i] = Tools.testeDatei(m,i,vier.dataDir,anzahlSteine);
                        if( rueckWert[i] <0 ){
                            return 1;
                        }
                        else if( rueckWert[i]==0 ){
                            unentschieden = true;
                        }
                        else{
                            niederlage=true;
                        }
                    }catch(Exception e){
                        e.printStackTrace();
                        System.err.println(e.getMessage());
                        rueckWert[i]=-500;
                    }
                }
            }
            if( unentschieden || !niederlage ) return 0;
            return -1;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] != -500 ) continue;
            rueckWert[i]=Tools.pruefDatei(m,spieltiefe,i,vier.dataListe,vier.dataDir,anzahlSteine);
            if( rueckWert[i] <0 ){
                return 1;
            }
            else if( rueckWert[i]==0 ){
                unentschieden = true;
            }
            else{
                niederlage = true;
            }
        }
        if( unentschieden || !niederlage ) return 0;
        return -1;
    }
    
    /**gibt die Spalte zurck,in die gesetzt werden soll
     * bei einem Wert groesser als 1000000 ist das Spiel unentschieden
     * und zwar bei allen Feldern mit Wert 1, sonst Wert 2
     * wird bentigt in Verbindung mit C-Programm
     */
    static int pruefe2(int n[],int spieltiefe) throws Exception{
                            //gibt die Spalte zurck,in die gesetzt werden soll
        int m[] = new int[2];
        m[0] = n[0];
        m[1] = n[1];
        int spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int anzahlSiege = 0;
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(m,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(m,i) ){
                    return i;
                }
            }
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            rueckWert[i]=Tools.pruefeSchnell(m,spieltiefe,i);
            if( rueckWert[i] <0 ){
                anzahlSiege++;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        if( anzahlSiege > 0 ){//gewonnen
            int anzahlZuege=100;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 || rueckWert[i] >= 0)continue;
                tmp = (-rueckWert[i]/10);
                if( tmp < anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return spalte;
        }
        if( anzahlUnentschieden > 0 ){//unentschieden
            int wert = 0;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == 0 ){
                    wert = wert*10+1;
                }
                else if( rueckWert[i] == -1000){
                    wert = wert*10+3;
                }
                else{
                    wert = wert*10+2;
                }
            }
            return wert;
        }
        if( anzahlNiederlagen > 0 ){//verloren
            int anzahlZuege=-1;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 )continue;
                tmp = (rueckWert[i]/10);
                if( tmp > anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return spalte;
        }
        throw new Exception("Spielfeld ist schon voll");
    }
    
    static int pruefe(int n[],int spieltiefe) throws Exception{
                            //gibt die Spalte zurck,in die gesetzt werden soll
        int m[] = new int[2];
        m[0] = n[0];
        m[1] = n[1];
        int spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int anzahlSiege = 0;
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(m,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(m,i) ){
                    return i;
                }
            }
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            rueckWert[i]=Tools.pruefe(m,spieltiefe,i);
            if( rueckWert[i] <0 ){
                anzahlSiege++;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        if( anzahlSiege > 0 ){//gewonnen
            int anzahlZuege=100;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 || rueckWert[i] >= 0)continue;
                tmp = (-rueckWert[i]/10);
                if( tmp < anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return spalte;
        }
        if( anzahlUnentschieden > 0 ){//unentschieden
            spalte = -1;
            int zufall = (int)(Math.random()*anzahlUnentschieden+1);
            while( zufall > 0 ){
                spalte++;
                if( rueckWert[spalte]==0 )zufall--;
            }
            return spalte;
        }
        if( anzahlNiederlagen > 0 ){//verloren
            int anzahlZuege=-1;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 )continue;
                tmp = (rueckWert[i]/10);
                if( tmp > anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return spalte;
        }
        throw new Exception("Spielfeld ist schon voll");
    }
    
    //Sucht schnellsten Weg um zu gewinnen    
    static int pruefe(int m[],int spieltiefe,int spalte)throws Exception{
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        spieltiefe--;
        
        spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int anzahlSiege = 0;
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(n,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(n,i) ){
                    return 10+i;
                }
            }
        }
        if( spieltiefe <= 0 ){
            return 0;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            rueckWert[i]=Tools.pruefe(n,spieltiefe,i);
            if( rueckWert[i] <0 ){
                anzahlSiege++;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        if( anzahlSiege > 0 ){//gewonnen
            int anzahlZuege=100;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 || rueckWert[i] >= 0)continue;
                tmp = (-rueckWert[i]/10);
                if( tmp < anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return 10+10*anzahlZuege+spalte;
        }
        if( anzahlUnentschieden > 0 ){//unentschieden
            return 0;
        }
        if( anzahlNiederlagen > 0 ){//verloren
            int anzahlZuege=-1;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 )continue;
                tmp = (rueckWert[i]/10);
                if( tmp > anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return -(10+10*anzahlZuege+spalte);
        }
        return 0;//Spielfeld ist voll, also unentschieden
    }
    
    static int sieg(int m[],int spieltiefe,int spalte)throws Exception{
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        spieltiefe--;
        
        spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(n,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(n,i) ){
                    return 10+i;
                }
            }
        }
        if( spieltiefe <= 0 ){
            return 0;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            rueckWert[i]=Tools.niederlage(n,spieltiefe,i);
            if( rueckWert[i] <0 ){
                return 10+10*(-rueckWert[i]/10)+i;
            }
        }
        return 0;//nicht gewonnen
    }
    
    static int siegDatei(int m[],int spieltiefe,int spalte,String dataListe,
            File dataDir,int anzahlSteine)throws Exception{
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        spieltiefe--;
        anzahlSteine++;
        
        spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(n,i) == 6 )rueckWert[i]=-1000;
            else{
                if( Tools.gewinnt(n,i) ){
                    return 1;
                }
                rueckWert[i] = -500;
            }
        }
        if( dataListe.indexOf(","+Integer.toString(anzahlSteine+1)+",") != -1 ){
            for(int i=0;i<7;i++){
                if( rueckWert[i] != -1000 ){
                    try{
                        rueckWert[i] = Tools.testeDatei(n,i,dataDir,anzahlSteine);
                        if( rueckWert[i] <0 ){
                            return 1;
                        }
                    }catch(Exception e){
                        e.printStackTrace();
                        System.err.println(e.getMessage());
                        rueckWert[i]=-500;
                    }
                }
            }
            return 0;
        }
        else if( spieltiefe <= 0 ){
            return 0;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] != -500 ) continue;
            rueckWert[i]=Tools.niederlageDatei(n,spieltiefe,i,
                                        dataListe,dataDir,anzahlSteine);
            if( rueckWert[i] <0 ){
                return 1;
            }
        }
        return 0;//nicht gewonnen
    }

    static int niederlageDatei(int m[],int spieltiefe,int spalte,String dataListe,
            File dataDir,int anzahlSteine)throws Exception{
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        spieltiefe--;
        anzahlSteine++;
        
        spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        boolean niederlage = false;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(n,i) == 6 )rueckWert[i]=-1000;
            else{
                if( Tools.gewinnt(n,i) ){
                    return 0;
                }
                rueckWert[i] = -500;
            }
        }
        if( dataListe.indexOf(","+Integer.toString(anzahlSteine+1)+",") != -1 ){
            for(int i=0;i<7;i++){
                if( rueckWert[i] != -1000 ){
                    try{
                        rueckWert[i] = Tools.testeDatei(n,i,dataDir,anzahlSteine);
                        if( rueckWert[i] <=0 ){
                            return 0;
                        }
                        else{
                            niederlage = true;
                        }
                    }catch(Exception e){
                        e.printStackTrace();
                        System.err.println(e.getMessage());
                        rueckWert[i]=-500;
                    }
                }
            }
            if( niederlage )return -1;
            else return 0;
        }
        else if( spieltiefe <= 0 ){
            return 0;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] != -500 ) continue;
            rueckWert[i]=Tools.siegDatei(n,spieltiefe,i,dataListe,dataDir, 
                                                                  anzahlSteine);
            if( rueckWert[i] <=0 ){
                return 0;
            }
            else{
                niederlage = true;
            }
        }
        if( niederlage )return -1;
        return 0;//Spielfeld ist voll, also unentschieden
    }

    static int niederlage(int m[],int spieltiefe,int spalte)throws Exception{
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        spieltiefe--;
        
        spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        boolean niederlage = false;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(n,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(n,i) ){
                    return 0;
                }
            }
        }
        if( spieltiefe <= 0 ){
            return 0;
        }
        int tmp = 0;
        int j=-1;
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            rueckWert[i]=Tools.sieg(n,spieltiefe,i);
            if( rueckWert[i] <=0 ){
                return 0;
            }
            else if( rueckWert[i]>tmp ){
                tmp = rueckWert[i];
                j=i;
                niederlage = true;
            }
        }
        if( niederlage ){
            return -(10+10*(tmp/10)+j);
        }
        return 0;//Spielfeld ist voll, also unentschieden
    }
    
    static int pruefeSchnell(int m[],int spieltiefe,int spalte)throws Exception{
        boolean unentschieden = false;
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        spieltiefe--;
        
        spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(n,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(n,i) ){
                    return 10+i;
                }
            }
        }
        if( spieltiefe <= 0 ){
            return 0;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            if( unentschieden ){
                rueckWert[i]=Tools.niederlage(n,spieltiefe,i);
                if( rueckWert[i] < 0 ){
                    return 10+10*(-rueckWert[i]/10)+i;
                }
            }
            else{
                rueckWert[i]=Tools.pruefeSchnell(n,spieltiefe,i);
                if( rueckWert[i] <0 ){
                    return 10+10*(-rueckWert[i]/10)+i;
                }
                else if( rueckWert[i]==0 ){
                    unentschieden = true;
                }
                else{
                    anzahlNiederlagen++;
                }
            }
        }
        if( unentschieden ){//unentschieden
            return 0;
        }
        if( anzahlNiederlagen >0 ){//verloren
            //wenigstens noch den 'besten' Zug aussuchen
            int anzahlZuege=-1;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 )continue;
                tmp = (rueckWert[i]/10);
                if( tmp > anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return -(10+10*anzahlZuege+spalte);
        }
        return 0;//Spielfeld ist voll, also unentschieden
    }
    
    static int pruefDatei(int m[],int spieltiefe,int spalte,String dataListe, File dataDir,int anzahlSteine)throws Exception{
        boolean unentschieden = false;
        boolean niederlage = false;
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        spieltiefe--;
        anzahlSteine++;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(n,i) == 6 )rueckWert[i]=-1000;
            else{
                if( Tools.gewinnt(n,i) ){
                    return 1;
                }
                rueckWert[i] = -500;
            }
        }
        if( dataListe.indexOf(","+Integer.toString(anzahlSteine+1)+",") != -1 ){
            for(int i=0;i<7;i++){
                if( rueckWert[i] != -1000 ){
                    try{
                        rueckWert[i] = Tools.testeDatei(n,i,dataDir,anzahlSteine);
                        if( rueckWert[i] <0 ){
                            return 1;
                        }
                        else if( rueckWert[i]==0 ){
                            unentschieden = true;
                        }
                        else{
                            niederlage = true;
                        }
                    }catch(Exception e){
                        e.printStackTrace();
                        System.err.println(e.getMessage());
                        rueckWert[i]=-500;
                    }
                }
            }
            if( unentschieden || !niederlage ) return 0;
            return -1;
        }
        else if( spieltiefe <= 0 ){
            return 0;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] != -500 ) continue;
            if( unentschieden ){
                rueckWert[i]=Tools.niederlageDatei(n,spieltiefe,i,
                                        dataListe,dataDir,anzahlSteine);
                if( rueckWert[i] < 0 ){
                    return 1;
                }
            }
            else{
                rueckWert[i]=Tools.pruefDatei(n,spieltiefe,i, 
                                        dataListe,dataDir,anzahlSteine);
                if( rueckWert[i] <0 ){
                    return 1;
                }
                else if( rueckWert[i]==0 ){
                    unentschieden = true;
                }
                else{
                    niederlage = true;
                }
            }
        }
        if( unentschieden || !niederlage ){//unentschieden
            return 0;
        }
        return -1;
    }
    
    //nimmt erstbesten Weg um zu gewinnen
    static int pruefeKurz(int n[],int spieltiefe) throws Exception{
                            //gibt die Spalte zurck,in die gesetzt werden soll
        int m[] = new int[2];
        m[0] = n[0];
        m[1] = n[1];
        int spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(m,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(m,i) ){
                    return i;
                }
            }
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            rueckWert[i]=Tools.pruefeKurz(m,spieltiefe,i);
            if( rueckWert[i] <0 ){
                return i;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        if( anzahlUnentschieden > 0 ){//unentschieden
            spalte = -1;
            int zufall = (int)(Math.random()*anzahlUnentschieden+1);
            while( zufall > 0 ){
                spalte++;
                if( rueckWert[spalte]==0 )zufall--;
            }
            return spalte;
        }
        if( anzahlNiederlagen > 0 ){//verloren
            int anzahlZuege=-1;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 )continue;
                tmp = (rueckWert[i]/10);
                if( tmp > anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return spalte;
        }
        throw new Exception("Spielfeld ist schon voll");
    }
    
    //nimmt erstbesten Weg um zu gewinnen,schneller als pruefeKurz
    static int pruefeSchnell(int n[],int spieltiefe) throws Exception{
                            //gibt die Spalte zurck,in die gesetzt werden soll
        int m[] = new int[2];
        m[0] = n[0];
        m[1] = n[1];
        int spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(m,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(m,i) ){
                    return i;
                }
            }
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            rueckWert[i]=Tools.pruefeSchnell(m,spieltiefe,i);
            //System.out.println("i: "+i+"  Rueckwert: "+rueckWert[i]);
            if( rueckWert[i] <0 ){
                return i;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        
        if( anzahlUnentschieden > 0 ){//unentschieden
            spalte = -1;
            int zufall = (int)(Math.random()*anzahlUnentschieden+1);
            while( zufall > 0 ){
                spalte++;
                if( rueckWert[spalte]==0 )zufall--;
            }
            return spalte;
        }
        if( anzahlNiederlagen > 0 ){//verloren
            int anzahlZuege=-1;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 )continue;
                tmp = (rueckWert[i]/10);
                if( tmp > anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return spalte;
        }
        throw new Exception("Spielfeld ist schon voll");
    }
    
    static int pruefeKurz(int m[],int spieltiefe,int spalte)throws Exception{
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        n = Tools.setze(n,spalte);
        spieltiefe--;
        
        spalte = -1000;// hier wird gespeichert, in welche Spalte gesetzt werden soll
        int anzahlUnentschieden = 0;
        int anzahlNiederlagen=0;
        int rueckWert[] = new int[7];
        for(int i=0;i<7;i++){
            if( Tools.getSpalte(n,i) == 6 )rueckWert[i]=-1000;
            else{
                rueckWert[i] = 0;
                if( Tools.gewinnt(n,i) ){
                    return 10+i;
                }
            }
        }
        if( spieltiefe <= 0 ){
            return 0;
        }
        for(int i=0;i<7;i++){
            if( rueckWert[i] == -1000 ) continue;
            rueckWert[i]=Tools.pruefeKurz(n,spieltiefe,i);
            if( rueckWert[i] <0 ){
                return 10+10*(-rueckWert[i]/10)+i;
            }
            else if( rueckWert[i]==0 ){
                anzahlUnentschieden++;
            }
            else{
                anzahlNiederlagen++;
            }
        }
        if( anzahlUnentschieden > 0 ){//unentschieden
            return 0;
        }
        if( anzahlNiederlagen > 0 ){//verloren
            int anzahlZuege=-1;
            int tmp;
            for(int i=0;i<7;i++){
                if( rueckWert[i] == -1000 )continue;
                tmp = (rueckWert[i]/10);
                if( tmp > anzahlZuege ){
                    anzahlZuege = tmp;
                    spalte = i;
                }
            }
            return -(10+10*anzahlZuege+spalte);
        }
        return 0;//Spielfeld ist voll, also unentschieden
    }
    
    static int[] spiegel(int m[]){
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        try{
            //Spielfeld
            for(int i=0;i<7;i++){
                for(int j=0;j<6;j++){
                    if( getBit(m,7*j+i)==1){
                        setBit(n,7*j+6-i);
                    }
                    else{
                        unsetBit(n,7*j+6-i);
                    }
                }
            }
            //Hoehen
            for(int i=0;i<7;i++){
                for(int j=0;j<3;j++){
                    if( getBit(m,43+3*i+j)==1 ){
                        setBit(n,43+3*(6-i)+j);
                    }
                    else{
                        unsetBit(n,43+3*(6-i)+j);
                    }
                }
            }
        }catch(Exception e){
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        return n;
    }
    
    static int[] invertiere(int m[]){
        int n[] = new int[2];
        n[0]=m[0];
        n[1]=m[1];
        try{
            for(int i=0;i<=42;i++){
                if( getBit(m,i)==1 ){
                    unsetBit(n,i);
                }
                else{
                    setBit(n,i);
                }
            }
        }catch(Exception e){
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        return n;
    }
    
    static int getSpalte(int m[],int spalte)throws Exception{
        int tmp1;
        int rueckWert;
    // in m stehen die 64 bit
    // m[1] sind die Bit 32-63
    // Bit 63 in m entspricht Bit 31 in m[1]
        if( spalte >= ANZAHLSPALTEN || spalte < 0){
            throw new Exception("Fehler in Fkt 'getSpalte()':\nVariable Spalte ungueltig");
        }
        else{
            tmp1 = 43+3*spalte;
            rueckWert = getBit(m,tmp1)+2*getBit(m,tmp1+1)+4*getBit(m,tmp1+2);
        }
    return rueckWert;
    }
    
    static int getBit(int stellung[],int position)throws Exception{
	int tmp1;
	int n=1;
	if( position < 0 || position > 63 ){
            throw new Exception("position: "+position+"\nUeberlauf in getBit");
   	}
   	if( position > 31 ){
            tmp1=stellung[1];
            position = position - 32;
   	}
   	else tmp1=stellung[0];
   	tmp1 = tmp1 >> position;
   	//printf("position: %d,m0: %d\n",position,m0);
   	return n & tmp1;
    }
    
    static int getBit(int zahl,int position)throws Exception{
	int n=1;
	if( position < 0 || position > 31 ){
            throw new Exception("position: "+position+"\nUeberlauf in getBit");
   	}
   	zahl = zahl >> position;
   	//printf("position: %d,m0: %d\n",position,m0);
   	return n & zahl;
    }
    
    static int gewinnt(int m[])throws Exception{// Testet ob der Spieler mit einem Zug gewinnen kann
                                            // ja == 1*10+Spaltennummer (Spaltennummer
                                     // der Spalte die der Spieler whlen mu 0-6)
                                            // nein == 0
       int i,tmp1,tmp2,tmp3,tmp4,tmp5,spalt;
       int spalte[]=new int[ANZAHLSPALTEN];//speichert die aktuelle Anzahl an Steinen in den Spalten
       //printf("Aufruf von gewinnt amZug: %d\n",getBit(m,42));
       //zeichneMatrix(m);
       for( i=0;i<ANZAHLSPALTEN;i++ ){
          spalte[i] = getSpalte(m,i);
       }
       for( i=0;i<ANZAHLSPALTEN;i++ ){
          if( spalte[i] == 6 )continue;
          tmp2 = 1;//zaehlt die Steine in eine Richtung
          tmp1=spalte[i]*ANZAHLSPALTEN+i;//aktuelle Position
          spalt=i-1;
          tmp3=tmp1-8;//Position
          //testen von linksunten nach rechtsoben
          while( spalt>=0 && tmp3 >=0 && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN 
                                                    && getBit(m,tmp3) == getBit(m,42) ){
            tmp2++;
             spalt--;
             //printf("tmp2: %d\ttmp3: %d\n",tmp2,tmp3);
             tmp3=tmp3-8;
          }
          tmp3 = tmp1+8;
          spalt = i+1;
          while( spalt<ANZAHLSPALTEN && tmp3 <42 && 
                        spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                        getBit(m,tmp3) == getBit(m,42) ){
             tmp2++;
             spalt++;
             //printf("tmp2: %d\ttmp3: %d\n",tmp2,tmp3);
             tmp3=tmp3+8;
          }
          //testen von rechtsunten nach linksoben
          tmp4 = 1;
          tmp3=tmp1-6;
          spalt = i+1;
          while( spalt<ANZAHLSPALTEN && tmp3 >=0 && 
                            spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                            getBit(m,tmp3) == getBit(m,42) ){
            tmp4++;
             spalt ++;
             //printf("tmp4: %d\ttmp3: %d\n",tmp4,tmp3);
             tmp3=tmp3-6;
          }
          spalt = i-1;
          tmp3 = tmp1+6;
          while( spalt >=0 && tmp3 <=41 && 
                    spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                    getBit(m,tmp3) == getBit(m,42) ){
            tmp4++;
             spalt--;
             //printf("tmp4: %d\ttmp3: %d\n",tmp4,tmp3);
             tmp3=tmp3+6;
          }
          //testen von links nach rechts
          tmp5 = 1;
          spalt = i-1;
          tmp3 = tmp1-1;
          while( spalt >=0 && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                                               getBit(m,tmp3) == getBit(m,42) ){
            tmp5++;
             tmp3--;
             spalt--;
          }
          spalt = i+1;
          tmp3 = tmp1+1;
          //printf("gezhlt: %d spalt: %d tmp3: %d\n",tmp5,spalt,tmp3);
          while( spalt <ANZAHLSPALTEN && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN 
                                            && getBit(m,tmp3) == getBit(m,42) ){
            tmp5++;
             spalt++;
             tmp3++;
          }
          if( tmp2 > 4 || tmp4 > 4 || tmp5 > 4){
             return 10+i;
          }
          if( tmp2 == 4 || tmp4 == 4 || tmp5 == 4){
            return 10+i;
          }//sonst nicht gewonnen
          if( spalte[i] >= 3 ){
            tmp1=(spalte[i]-1)*ANZAHLSPALTEN+i;
            if( getBit(m,tmp1)==getBit(m,42) && 
                                getBit(m,tmp1-ANZAHLSPALTEN)==getBit(m,42) &&
                                getBit(m,tmp1-14)==getBit(m,42) ){
                    return 10+i;
             }
          }
       }
       return 0;
    }
    
    static boolean gewinnt(int m[],int column)throws Exception{// Testet ob der Spieler gewinnt wenn er
        //den nchsten Stein in die Spalte 'column' setzt
                                            // ja == 1*10+Spaltennummer (Spaltennummer
                                     // der Spalte die der Spieler whlen mu 0-6)
                                            // nein == 0
       int i,tmp1,tmp2,tmp3,tmp4,tmp5,spalt;
       int spalte[]=new int[ANZAHLSPALTEN];//speichert die aktuelle Anzahl an Steinen in den Spalten
       //printf("Aufruf von gewinnt amZug: %d\n",getBit(m,42));
       //zeichneMatrix(m);
       for( i=0;i<ANZAHLSPALTEN;i++ ){
          spalte[i] = getSpalte(m,i);
       }
       for( i=0;i<ANZAHLSPALTEN;i++ ){
          if( i != column )continue;
          tmp2 = 1;//zaehlt die Steine in eine Richtung
          tmp1=spalte[i]*ANZAHLSPALTEN+i;//aktuelle Position
          spalt=i-1;
          tmp3=tmp1-8;//Position
          //testen von linksunten nach rechtsoben
          while( spalt>=0 && tmp3 >=0 && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN 
                                                    && getBit(m,tmp3) == getBit(m,42) ){
            tmp2++;
             spalt--;
             //printf("tmp2: %d\ttmp3: %d\n",tmp2,tmp3);
             tmp3=tmp3-8;
          }
          tmp3 = tmp1+8;
          spalt = i+1;
          while( spalt<ANZAHLSPALTEN && tmp3 <42 && 
                        spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                        getBit(m,tmp3) == getBit(m,42) ){
             tmp2++;
             spalt++;
             //printf("tmp2: %d\ttmp3: %d\n",tmp2,tmp3);
             tmp3=tmp3+8;
          }
          //testen von rechtsunten nach linksoben
          tmp4 = 1;
          tmp3=tmp1-6;
          spalt = i+1;
          while( spalt<ANZAHLSPALTEN && tmp3 >=0 && 
                            spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                            getBit(m,tmp3) == getBit(m,42) ){
            tmp4++;
             spalt ++;
             //printf("tmp4: %d\ttmp3: %d\n",tmp4,tmp3);
             tmp3=tmp3-6;
          }
          spalt = i-1;
          tmp3 = tmp1+6;
          while( spalt >=0 && tmp3 <=41 && 
                    spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                    getBit(m,tmp3) == getBit(m,42) ){
            tmp4++;
             spalt--;
             //printf("tmp4: %d\ttmp3: %d\n",tmp4,tmp3);
             tmp3=tmp3+6;
          }
          //testen von links nach rechts
          tmp5 = 1;
          spalt = i-1;
          tmp3 = tmp1-1;
          while( spalt >=0 && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                                               getBit(m,tmp3) == getBit(m,42) ){
            tmp5++;
             tmp3--;
             spalt--;
          }
          spalt = i+1;
          tmp3 = tmp1+1;
          //printf("gezhlt: %d spalt: %d tmp3: %d\n",tmp5,spalt,tmp3);
          while( spalt <ANZAHLSPALTEN && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN 
                                            && getBit(m,tmp3) == getBit(m,42) ){
            tmp5++;
             spalt++;
             tmp3++;
          }
          if( tmp2 > 4 || tmp4 > 4 || tmp5 > 4){
             return true;//10+i;
          }
          if( tmp2 == 4 || tmp4 == 4 || tmp5 == 4){
            return true;//10+i;
          }
          else{
            /*printf("nicht gewonnen\n");*/
          }
          if( spalte[i] >= 3 ){
            tmp1=(spalte[i]-1)*ANZAHLSPALTEN+i;
            if( getBit(m,tmp1)==getBit(m,42) && 
                                getBit(m,tmp1-ANZAHLSPALTEN)==getBit(m,42) &&
                                getBit(m,tmp1-14)==getBit(m,42) ){
                    return true;//10+i;
             }
          }
       }
       return false;//0;
    }
    
    static boolean gewinnt(Spielfeld2 feld,int m[],int column)throws Exception{// Testet ob der Spieler gewinnt wenn er
        //den nchsten Stein in die Spalte 'column' setzt
                                            // ja == 1*10+Spaltennummer (Spaltennummer
                                     // der Spalte die der Spieler whlen mu 0-6)
                                            // nein == 0
        boolean rueckWert = false;
       int i,tmp1,tmp2,tmp3,tmp4,tmp5,spalt;
       int spalte[]=new int[ANZAHLSPALTEN];//speichert die aktuelle Anzahl an Steinen in den Spalten
       for( i=0;i<ANZAHLSPALTEN;i++ ){
          spalte[i] = getSpalte(m,i);
       }
       for( i=0;i<ANZAHLSPALTEN;i++ ){
          if( i != column )continue;
          tmp2 = 1;//zaehlt die Steine in eine Richtung
          tmp1=spalte[i]*ANZAHLSPALTEN+i;//aktuelle Position
          //zeil=tmp1/ANZAHLSPALTEN-1;
          spalt=i-1;
          tmp3=tmp1-8;//Position
          //testen von linksunten nach rechtsoben
          while( spalt>=0 && tmp3 >=0 && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN 
                                                    && getBit(m,tmp3) == getBit(m,42) ){
            tmp2++;
             spalt--;
             //printf("tmp2: %d\ttmp3: %d\n",tmp2,tmp3);
             tmp3=tmp3-8;
          }
          tmp3 = tmp1+8;
          spalt = i+1;
          while( spalt<ANZAHLSPALTEN && tmp3 <42 && 
                        spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                        getBit(m,tmp3) == getBit(m,42) ){
             tmp2++;
             spalt++;
             tmp3=tmp3+8;
          }
          //testen von rechtsunten nach linksoben
          tmp4 = 1;
          tmp3=tmp1-6;
          spalt = i+1;
          while( spalt<ANZAHLSPALTEN && tmp3 >=0 && 
                            spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                            getBit(m,tmp3) == getBit(m,42) ){
            tmp4++;
             spalt ++;
             tmp3=tmp3-6;
          }
          spalt = i-1;
          tmp3 = tmp1+6;
          while( spalt >=0 && tmp3 <=41 && 
                    spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                    getBit(m,tmp3) == getBit(m,42) ){
            tmp4++;
             spalt--;
             tmp3=tmp3+6;
          }
          //testen von links nach rechts
          tmp5 = 1;
          spalt = i-1;
          tmp3 = tmp1-1;
          while( spalt >=0 && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                                               getBit(m,tmp3) == getBit(m,42) ){
            tmp5++;
             tmp3--;
             spalt--;
          }
          spalt = i+1;
          tmp3 = tmp1+1;
          while( spalt <ANZAHLSPALTEN && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN 
                                            && getBit(m,tmp3) == getBit(m,42) ){
            tmp5++;
             spalt++;
             tmp3++;
          }
          int j=1;//Position, wo in feldRot geschrieben wird
          if( tmp2 >= 4 || tmp4 >= 4 || tmp5 >= 4){
              i=column;
              tmp1=spalte[i]*ANZAHLSPALTEN+i;//aktuelle Position
              feld.feldRot[0]=tmp1;
              spalt=i-1;
              if( tmp2 >= 4 ){
                  tmp3=tmp1-8;//Position
                  //testen von linksunten nach rechtsoben
                  while( spalt>=0 && tmp3 >=0 && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN 
                                                            && getBit(m,tmp3) == getBit(m,42) ){
                     spalt--;
                     feld.feldRot[j]=tmp3;
                     j++;
                     tmp3=tmp3-8;
                  }
                  tmp3 = tmp1+8;
                  spalt = i+1;
                  while( spalt<ANZAHLSPALTEN && tmp3 <42 && 
                                spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                                getBit(m,tmp3) == getBit(m,42) ){
                     spalt++;
                     feld.feldRot[j]=tmp3;
                     j++;
                     tmp3=tmp3+8;
                  }
              }
              if(tmp4 >= 4){
                  tmp3=tmp1-6;
                  spalt = i+1;
                  while( spalt<ANZAHLSPALTEN && tmp3 >=0 && 
                                    spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                                    getBit(m,tmp3) == getBit(m,42) ){
                     spalt ++;
                     feld.feldRot[j]=tmp3;
                     j++;
                     tmp3=tmp3-6;
                  }
                  spalt = i-1;
                  tmp3 = tmp1+6;
                  while( spalt >=0 && tmp3 <=41 && 
                            spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                            getBit(m,tmp3) == getBit(m,42) ){
                     spalt--;
                     feld.feldRot[j]=tmp3;
                     j++;
                     tmp3=tmp3+6;
                  }
              }
              if(tmp5 >= 4){
                  spalt = i-1;
                  tmp3 = tmp1-1;
                  while( spalt >=0 && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN && 
                                                       getBit(m,tmp3) == getBit(m,42) ){
                    feld.feldRot[j]=tmp3;
                    j++;
                    tmp3--;
                    spalt--;
                  }
                  spalt = i+1;
                  tmp3 = tmp1+1;
                  //printf("gezhlt: %d spalt: %d tmp3: %d\n",tmp5,spalt,tmp3);
                  while( spalt <ANZAHLSPALTEN && spalte[tmp3%ANZAHLSPALTEN]>tmp3/ANZAHLSPALTEN 
                                                    && getBit(m,tmp3) == getBit(m,42) ){
                    spalt++;
                    feld.feldRot[j]=tmp3;
                    j++;
                    tmp3++;
                  }
              }
              rueckWert = true;//10+i;
          }
          if( spalte[i] >= 3 ){
            tmp1=(spalte[i]-1)*ANZAHLSPALTEN+i;
            if( getBit(m,tmp1)==getBit(m,42) && 
                                getBit(m,tmp1-ANZAHLSPALTEN)==getBit(m,42) &&
                                getBit(m,tmp1-14)==getBit(m,42) ){
                    feld.feldRot[0]=tmp1;
                    feld.feldRot[j]=tmp1+7;
                    feld.feldRot[j+1]=tmp1;//wird von 0 bis 41 gezhlt
                    feld.feldRot[j+2]=tmp1-7;
                    feld.feldRot[j+3]=tmp1-14;
                    rueckWert = true;//10+i;
             }
          }
       }
       return rueckWert;//0;
    }
    
    public static int setBit(int zahl, int position)throws Exception{
        int n=1;
        if( position < 0 || position > 31 ){
            throw new Exception("position: "+position+"\nUeberlauf in setBit");
        }
        n = n << position;
        zahl = zahl | n;
        return zahl;
    }
    
    public static int[] setBit(int spielfeld[],int position)throws Exception{
        int tmp1,tmp2;
        int n=1;
        tmp2 = 0;//speichert, welche der beiden integers gendert wurden
        if( position < 0 || position > 63 ){
            throw new Exception("position: "+position+"\nUeberlauf in setBit");
        }
        if( position > 31 ){
                tmp2 = 1;
                tmp1=spielfeld[1];
            position = position - 32;
        }
        else tmp1=spielfeld[0];
        n = n << position;
        spielfeld[tmp2] = tmp1 | n;
        return spielfeld;
    }

    public static int[] unsetBit(int spielfeld[],int position)throws Exception{
        int tmp1,tmp2;
        int n=1;
        tmp2 = 0;//speichert, welche der beiden integers gendert wurden
        if( position < 0 || position > 63 ){
            throw new Exception("position: "+position+"\nUeberlauf in unsetBit");
        }
        if( position > 31 ){
            tmp2 = 1;
            tmp1=spielfeld[1];
        position = position - 32;
        }
        else tmp1=spielfeld[0];
        n = n << position;
        n = ~n;
        spielfeld[tmp2]=tmp1 & n;
        return spielfeld;
    }
    
}
