package VierGewinnt;

/**
 * Jede Spielstellung soll in 2 Bit gespeichert werden:
 *  Dazu werden Dateien der Form x1x2x3x4x5x6x7.dat angelegt, wobei die 7 'xi'
 *  die Hoehen der 7 Spalten anzeigen.
 *  In jeder Datei werden pro Spielstand 2 Bit benoetigt: 
 *      1 Bit fuer Unentschieden oder noch nicht ausgewerten,
 *      1 Bit fuer Sieg/Niederlage bzw. Weiss/Schwarz (noch ueberlegen)
 *  Die Datei hat die Groesse 2*2^(xgesamt): (mit xgesamt=x1+x2+x3+x4+x5+x6+x7)
 *      Spielstand wird an der Position
 *          2*( 2^0*a1+2^1*a2+...+2^(xgesamt-1)*a(xgesamt) ) bzw.
 *          2^1*a1+...+2^xgesamt*a(xgesamt)
 *      gespeichert.
 **/
public class Zaehler{
    
    public static void main(String args[]){
        final int maxSteine = 22;
        double gbyteGesamt = 0.0;
        int anzahlDateienGesamt = 0;
        int anzahl[]=new int[maxSteine+1];
        for( int i=0;i<=maxSteine;i++){
            anzahl[i]=0;
        }
        int anzahlSteine;
        for(int a=0;a<7;a++){
            for(int b=0;b<7;b++){
                System.out.println("b: "+b);
                for(int c=0;c<7;c++){
                    if( a+b+c > maxSteine )break;
                    for(int d=0;d<7;d++){
                        for(int e=0;e<7;e++){
                            if( a+b+c+d+e>maxSteine )break;
                            for(int f=0;f<7;f++){
                                for(int g=0;g<7;g++){
                                    anzahlSteine=a+b+c+d+e+f+g;
                                    /*System.out.println("Anzahl Steine: "+anzahlSteine);
                                    System.out.println("a "+a);
                                    System.out.println("b "+b);
                                    System.out.println("c "+c);
                                    System.out.println("d "+d);
                                    System.out.println("e "+e);
                                    System.out.println("f "+f);
                                    System.out.println("g "+g);*/
                                    if( anzahlSteine > maxSteine )break;
                                    anzahl[anzahlSteine]++;
                                    //System.out.println(anzahl[anzahlSteine]);
                                }
                            }
                        }
                    }
                }
            }
        }
        for(int i=0;i<=maxSteine;i++){
            System.out.println("Steine: "+i+"\tAnzahl Dateien: "+anzahl[i]);
            anzahlDateienGesamt = anzahlDateienGesamt + anzahl[i];
        }
        System.out.println();
        for(int i=0;i<=maxSteine;i++){
            System.out.println("Steine: "+i+"\tMbyte pro Datei: "
                    +(2*Math.pow(2,i)/(8*1000*1000) ) );
        }
        System.out.println();
        for(int i=0;i<=maxSteine;i++){
            double mbyte = 2*Math.pow(2,i)/(8*1000*1000)*anzahl[i];
            System.out.println("Steine: "+i+"\tMbyte gesamt: "
            + mbyte);
            gbyteGesamt = gbyteGesamt+mbyte/1000;
        }
        System.out.println();
        System.out.println("Gbyte Gesamt: "+gbyteGesamt);
        System.out.println("Dateien Gesamt: "+anzahlDateienGesamt);
        System.out.println();
        try{
            int gueltig[]=new int[32];
            int ungueltig[]=new int[32];
            gueltig[0]=0;
            ungueltig[0]=0;
            for(int i=1;i<32;i++){
                gueltig[i]=0;
                ungueltig[i]=0;
                int zahl=0;
                while(Tools.getBit(zahl,i)==0){
                    int wert = 0;
                    for( int j=0;j<i;j++ ){
                        if( Tools.getBit(zahl,j)==0 )wert++;
                        else wert --;
                    }
                    if( wert == i%2 )gueltig[i]++;
                    else ungueltig[i]++;
                    zahl++;
                }
                System.out.println("Gueltig mit "+i+" Steinen: "+gueltig[i]);
                System.out.println("Ungueltig mit "+i+" Steinen: "+ungueltig[i]);
            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    
}